<?php

function makegraph($days,$group,$fpath,$fpost,&$year,$till="NOW()") {

if ( isset($till) && !empty($till) && strcmp($till,"NOW()") )
  $till = "'".$till."'";

$c_days = $days;

$D_HOME="/home/isp11709/domains/dom.my.waw.pl";
global $loc_color;
global $loc_index;

// those are all locations
$loc_plot = array(
  "barometr",
  "higrometrI",
  "higrometrO",
//  "wiatr",
  "punkt_rosy",
//  "opad1h",
  "cien",
  "alkowa",
  "hall",
  "lazienka",
  "serwerownia",
  "salon",
  "dach",
  "kacper",
  "ola",
  "strych"
//  "przedsionek"
);

// loc_group assignes every location to specific group
// $group controls which group shall be printed
$loc_group = array(
  3,
  4,
  4,
//  5,
  7,
//  6,
  2,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  1
//  1
);

$nplot = 14;

$grid_sec = 15*60.0;
$accuracy = 0.7;

require_once ($D_HOME."/cron/sources/generic.php");

temp_open();
temp_init();

switch ($days) {
  case 1:
  default:
    $Title = "Dobowe zmiany temperatury od";
    $date_format = "H:i";
    if ( $group == 5 ) {	// wiatr
      $height = 82;
      $bmarg  = 5;
    } else if ( $group == 4 ) {	// higrometr
      $height = 82;
      $bmarg  = 5;
    } else if ( $group == 3 ) {	// barometer
      $height = 82;
      $bmarg  = 5;
    } else if ( $group == 2 ) {	// temp zewnetrzna
      $height = 92;
      $bmarg  = 5;
    } else {			// temp wewnetrzna
      $height = 288;		// 256
      $bmarg  = 45;
      $group = 1;
    }
    $width = 550;
    $x_steps = 4;
    $days = 1;
    break;
  case 2:
    $Title = "Zmiany temperatury w cigu 48 godzin";
    $date_format = "d-m H:i";
    if ( $group == 5 ) {	// wiatr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 4 ) {	// higrometr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 3 ) {	// barometer
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 2 ) {	// temp zewnetrzna
      $height = 100;
      $bmarg  = 5;
    } else {			// temp wewnetrzna
      $height = 240;
      $bmarg  = 45;
      $group = 1;
    }
    $width = 550;
    $x_steps = 4;
    break;
  case 7:
    $Title = "Tygodniowe zmiany temperatury";
    $date_format = "d-m H:i";
    if ( $group == 5 ) {	// wiatr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 4 ) {	// higrometr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 3 ) {	// barometer
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 2 ) {
      $height = 130;
      $bmarg  = 5;
    } else {
      $height = 230;
      $bmarg  = 75;
      $group = 1;
    }
    $width = 760;
    $x_steps = 24;
    break;
  case 30:
    $Title = "Miesiczne zmiany temperatury";
    $date_format = "d-m H:i";
    if ( $group == 5 ) {	// wiatr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 4 ) {	// higrometr
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 3 ) {	// barometer
      $height = 104;
      $bmarg  = 5;
    } else if ( $group == 2 ) {
      $height = 130;
      $bmarg  = 5;
    } else {
      $height = 230;
      $bmarg  = 75;
      $group = 1;
    }
    $width = 760;
    $x_steps = 96;
    break;
}
// construct (upon $lock_plot array) location specific query substring
$q_locs = "AND (";
$glp = 0;
for ( $p = 0; $p < $nplot; ++$p ) {
  if ( !$group || ( $group == $loc_group[$p] ) ) { 
    $g_plot[$p] = $glp;
    $plot_index[$loc_plot[$p]] = $glp;
    if ( !$glp )
      $q_locs = " AND (";
    else
      $q_locs = $q_locs."OR"; 
    $q_locs = $q_locs." (loc='$loc_plot[$p]') ";
    ++$glp;
  } else
    $g_plot[$p] = -1;
}
if ( $glp )
  $q_locs = $q_locs.")";
else
  $q_locs = "FALSE)";	// internal error - Trying to plot non-existing group

// get data from database
$query = "SELECT UNIX_TIMESTAMP(dt),tm,loc FROM temp WHERE (UNIX_TIMESTAMP(dt)>=UNIX_TIMESTAMP(".$till.")-86400.0*$days) $q_locs ORDER BY dt DESC";

$q = mysql_query($query);
//
// set_time_limit(300);

// assign first datapoint
$line = mysql_fetch_row($q);

$ldt = floor($line[0]/60.0)*60.0;
$ltm = $line[1];
$lloc= $line[2];

$fcore = "graph".str_fn($c_days,$ldt).$fpost;
$fname = $fpath.$fcore;
$year = str_fn(0,$ldt);

$dbn = mysql_num_rows($q);

// those are not handled yet
if ( $dbn == 0 ) {
  $dt[0] = date("U");
  $tm[0] = 0;
  $dl[0] = "";
  $dt[$nplot-1] = date("U")-$days*24*60;
  $tm[$nplot-1] = 0;
  $ldt = $dt[1];
  $ltm = 0;
  $lloc = 1000;
} else if ( $dbn == 1 ) {
  $dt[0] = $ldt;
  $dt[$nplot-1] = date("U")-$days*24*60;
  $tm[0] = $ltm;
  $tm[$nplot-1] = $ltm;
}

$l = 0;
$n = 0;
$next = 0;
for ( $x = 0; $x < $nplot; ++$x ) {
  $p = $g_plot[$x];
  if ( ($p >= 0) ) {
    $g_dt[$p][$n] = $ldt;
//    $g_tm[$p][$n] = $ltm;
    if ( !isset($g_tm[$p][$n]) )
      $g_tm[$p][$n] = "";
  }
}
// take care for the rest datapoints
for ( $cnt = $dbn; $cnt > 0; --$cnt ) {
  $p = $plot_index[$lloc];
  $g_tm[$p][$n-$next] = $ltm;
  $line = mysql_fetch_row($q);
  $same_time = ((abs($ldt) - abs($line[0])) < $accuracy*$grid_sec);
  if ( $same_time )
    $n -= $next;
  else {
    for ( $p = 0; $p < $glp; ++$p ) {
      $g_dt[$p][$n] = $ldt;
      if ( !isset($g_tm[$p][$n]) )
        $g_tm[$p][$n] = "";
    }
  }
  if ( $cnt == 1 ) {
    ++$n;
    break;
  }
  $next = 1;
  while ( abs(abs($ldt)-abs(floor($line[0]/60.0)*60.0) ) > ($next+$accuracy)*$grid_sec ) {
    for ( $p = 0; $p < $glp; ++$p ) {
      $g_dt[$p][$n+$next] = $ldt - $next*$grid_sec;
      $g_tm[$p][$n+$next] = "";
    }
    ++$next;
  }
  $n += $next;
  $next = 1;
  $ldt = floor($line[0]/60.0)*60.0;
  $ltm = $line[1];
  $lloc= $line[2];
}

// we don't need to keep database connection from now
temp_close();

set_time_limit(300);

// keep the graph full range
// $g_dt[0][$n] = $g_dt[0][0] - 86400 * $days; 
// $g_tm[0][$n] = $g_tm[0][$n-1];
// ++$n;

$max_dt = date("d-m H:i",$g_dt[0][0]);
$min_dt = date("d-m H:i",$g_dt[0][$n-1]);

$InvalidLabels = FALSE;
for ( $x = 0; $x < $nplot; ++$x ) {
  $p = $g_plot[$x];
  $min_tm[$p] =  $g_dt[$p][0]; $max_tm[$p] =  $g_dt[$p][0];
  if ( $p >= 0 ) {
    for ( $i = 0; $i < $n/2; ++$i ) {
      $fdt = date($date_format,$g_dt[$p][$n-$i-1]);
      $ldt = date($date_format,$g_dt[$p][$i]);
      $g_dt[$p][$i] = $fdt;
      $g_dt[$p][$n-$i-1] = $ldt;
      $ftm = $g_tm[$p][$n-$i-1];
      $ltm = $g_tm[$p][$i];
      $g_tm[$p][$i] = $ftm;
      $g_tm[$p][$n-$i-1] = $ltm;
      if ( $min_tm[$p] > $ftm ) $min_tm[$p] = $ftm; 
      if ( $min_tm[$p] > $ltm ) $min_tm[$p] = $ltm; 
      if ( $max_tm[$p] < $ftm ) $max_tm[$p] = $ftm; 
      if ( $max_tm[$p] < $ltm ) $max_tm[$p] = $ltm; 
    }
    if ( $min_tm[$p] == $max_tm[$p] ) {
      $g_tm[$p][0] = 0; $g_tm[$p][$n-1] = 1;
      $InvalidLabels = TRUE;
    }
  }
}

// All the data are prepared so lets do make a graph
require_once ($D_HOME."/cron/sources/jpgraph.php");

// Common data for the graph: size, margins, type and y-axis tick interval
$graph = new Graph($width, $height,"auto");
$graph->img->SetMargin(45,5,5,$bmarg);	// l,r,t,b

for ( $x = 0; $x < $nplot; ++$x ) {
  if ( !$group || ( $group == $loc_group[$x] ) ) {
    $p = $g_plot[$x];
    $lineplot[$p] = new LinePlot($g_tm[$p]);
    $graph->Add($lineplot[$p]);
//    if ( $min_tm[$p] == $max_tm[$p] )
//      $graph->yaxis->HideLabels();
    $i = $loc_index["'".$loc_plot[$x]."'"];
    $lineplot[$p]->SetColor("$loc_color[$i]");
  }
}
$graph->SetScale("textlin");
$graph->yaxis->SetColor("#FFFFFF");
if ( ( $group > 1 ) || $InvalidLabels )
  $graph->xaxis->HideLabels();
else {
  $graph->xaxis->SetTickLabels($g_dt[0]);
  $graph->xaxis->SetLabelAngle(90);
  $graph->xaxis->SetTextLabelInterval(1);
}
if ( $InvalidLabels ) {
  $graph->yaxis->HideLabels();
}
$graph->xaxis->SetPos("min");
//$graph->yaxis->SetPos("min");
$graph->xscale->ticks->SupressZeroLabel(false);
$graph->xaxis->SetTextTickInterval($x_steps);
$graph->xaxis->SetColor("#FFFFFF");
$graph->SetMarginColor("#000000");
$graph->SetColor("#000000");

$graph->ygrid->SetColor("#004500");
//$graph->ygrid->Show(true,false);
$graph->ygrid->Show(!$InvalidLabels,false);
$graph->xgrid->SetColor("#004500");
//$graph->xgrid->Show(true,false);
$graph->xgrid->Show(!$InvalidLabels,false);

// set_time_limit(600);

$graph->Stroke($fname);
unset($g_dt);
unset($g_tm);
return $fcore;
}
?>